<!DOCTYPE html>
<html>
	<head>
		<title>PHP 多言語フレームワーク 公式サイト</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
		<meta name="description" content="PHP,多言語フレームワーク by @FengYi" />
		<meta name="keywords" content="PHP, PHP 框架, PHP框架, PHP 多言語フレームワーク, PHP多言語フレームワーク, PHP多语言, PHP多国语, 多语言, 多语言php, php网站多语言, php 切换页面语言, php 国家 语言, php实现多国语言切换, php 框架中英文切换, by @FengYi" />
		<link rel="stylesheet" href="assets/css/main.css" />
		<link rel="stylesheet" href="assets/css/lp-icon.css" />
		<link rel="shortcut icon" href="assets/logo/logo.ico" type="image/x-icon">
		<noscript><link rel="stylesheet" href="assets/css/noscript.css" /></noscript>
	</head>
	<body class="is-preload">

		<!-- Sidebar -->
			<section id="sidebar">
				<div class="inner">
					<nav>
						<ul>
							<li><a href="#intro">ようこそ</a></li>
							<li><a href="#language">利用可能な言語</a></li>
							<li><a href="#Example">示例</a></li>
						</ul>
					</nav>
				</div>
			</section>

		<!-- Wrapper -->
			<div id="wrapper">

				<!-- Intro -->
					<section id="intro" class="wrapper style1 fullscreen fade-up">
						<div class="inner">
							<h1>PHP 多言語フレームワーク v6.5</h1>
							<p>これは、さまざまな方法で実装されたフレームワークを介して実装された多言語プログラムであり、フレームワークの設計により、Webサイトがシンプル、高速、効率的に満足できるものになります。</p>
							<ul class="actions">
								<li><a href="https://lang-php.com/go/lp-docs" class="button scrolly">クイックガイド</a></li>
								<li><a href="https://lang-php.com/go/lp-downloads" class="button primary icon solid fa-download">ダウンロードする</a></li>
							</ul>
						</div>
					</section>

				<!-- Language -->
					<section id="language" class="wrapper style2 fade-up">
						<div class="inner">
							<h2>国または地域を選択します。</h2>
							<h3>北アメリカ</h3>
							<dt><span class="flag-icon flag-icon-us"></span>&nbsp; <a href="javascript:lang('en-US')">United States - English</a></dt>
							<br />
							<h3>アジア太平洋</h3>
							<dt><span class="flag-icon flag-icon-cn"></span>&nbsp; <a href="javascript:lang('zh-CN')">简体中文 - 中国</a></dt>
							<dt><span class="flag-icon flag-icon-tw"></span>&nbsp; <a href="javascript:lang('zh-TW')">繁體中文 - 中國</a></dt>
							<dt><span class="flag-icon flag-icon-jp"></span>&nbsp; <a href="javascript:lang('ja-JP')">日本 - 日本語</a></dt>
							<dt><span class="flag-icon flag-icon-kr"></span>&nbsp; <a href="javascript:lang('ko-KR')">대한민국 - 한국어</a></dt>
							<br />
							<h3>ヨーロッパ</h3>
							<dt><span class="flag-icon flag-icon-ru"></span>&nbsp; <a href="javascript:lang('ru-RU')">Россия - Русский</a></dt>
						</div>
					</section>

				<!-- Example -->
					<section id="Example" class="wrapper style3 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>ユーザー定義の選択 &amp; カタログ</h3>
									<p>最初の実行後のステアリング 'choose-country-region' ディレクトリ、メモリ機能と一致する言語ディレクトリを選択します。</p>
									<ul class="actions">
										<li><a href="example/01-directory" target="_blank" class="button primary fit">デモ</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-one" target="_blank" class="button alt fit">クイックガイド</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt2" class="wrapper style4 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>内部的にファイルをロードする &amp; 埋め込み</h3>
									<p>一致するディレクトリ内のファイルを自動的に検索しますファイルが見つからない場合は、デフォルトのファイルが選択されます。</p>
									<ul class="actions">
										<li><a href="example/02-embed" target="_blank" class="button primary fit">デモ</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-two" target="_blank" class="button alt fit">クイックガイド</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt3" class="wrapper style2 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>設定ファイルを読む &amp; 読み込み中</h3>
									<p>一致する言語ファイルを自動的に検索し、ロード後に呼び出します。文字列文字、配列、パラメーターなどを含むHTMLのその他をサポートします。</p>
									<ul class="actions">
										<li><a href="example/03-load" target="_blank" class="button primary fit">デモ</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-three" target="_blank" class="button alt fit">クイックガイド</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt4" class="wrapper style3 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>設定を保存する &amp; 構成</h3>
									<p>例と動的な読み取りと書き込み Cookies 異なる、構成をxmlまたはcfgに保存し、利用可能な優先言語パックを選択して選択し、優先するブラウザーのデフォルト言語を受け入れません。</p>
									<ul class="actions">
										<li><a href="example/04-settings" target="_blank" class="button primary fit">デモ</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-four" target="_blank" class="button alt fit">クイックガイド</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt5" class="wrapper style4 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>データベース &amp; 配列</h3>
									<p>合格 PDO ウェイ接続 SQL データベース、サポート MySQL、SQLite。そして配列を使用する（Array）この関数は、使用可能なすべてのデータをリストします。</p>
									<ul class="actions">
										<li><a href="example/05-database" target="_blank" class="button primary fit">デモ</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-fives" target="_blank" class="button alt fit">クイックガイド</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt6" class="wrapper style2 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>スタンドアロン &amp; ポータブル</h3>
									<p>使用する array() 言語構造は配列を構築し、関数を介してすべての操作を実行します;他のバージョンと比較して、ポータブルバージョンはファイルで完了します。</p>
									<ul class="actions">
										<li><a href="example/06-portable" target="_blank" class="button primary fit">デモ</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-six" target="_blank" class="button alt fit">クイックガイド</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

				<!-- License -->
					<section id="three" class="wrapper style1 fade-up">
						<div class="inner">
							<h2>多言語Webサイトを作成します。</h2>
							<p>他のフレームワークとは異なり、Lang-php は無制限に設計されており、複数のオプションを提供します。 これらのシナリオは、既存のルールを上書きするよりもはるかに簡単だと考えています。 数行のコードを追加するだけで、Webプロジェクトで使用する複数の言語の外観をカスタマイズできます。</p>
						</div>
					</section>

			</div>

		<!-- Footer -->
			<footer id="footer" class="wrapper style1-alt">
				<div class="inner">
					<ul class="menu">
						<li>&copy; Lang-php. All rights reserved</li>
						<li>Design: <a href="https://fengyi.tel">Yi</a></li>
					</ul>
				</div>
			</footer>

		<!-- Scripts -->
			<script src="assets/js/jquery.min.js"></script>
			<script src="assets/js/jquery.scrollex.min.js"></script>
			<script src="assets/js/jquery.scrolly.min.js"></script>
			<script src="assets/js/browser.min.js"></script>
			<script src="assets/js/breakpoints.min.js"></script>
			<script src="assets/js/util.js"></script>
			<script src="assets/js/main.js"></script>
			<script src="assets/js/lp.js"></script>
<?php include "themes/analytics.php"; ?>
	</body>
</html>