<!DOCTYPE html>
<html>
	<head>
		<title>PHP 다국어 프레임 워크 공식 웹 사이트</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
		<meta name="description" content="PHP,다국어 프레임 워크 by @FengYi" />
		<meta name="keywords" content="PHP, PHP 프레임, PHP프레임, PHP 다국어 프레임 워크, PHP다국어 프레임 워크, PHP다국어, PHP 다국어, 다국어, 다국어php, PHP 웹 사이트 다국어, php 페이지 언어 전환, php 국가 언어, 다국어 전환을위한 PHP, php 중국어와 영어 간 프레임 전환, by @FengYi" />
		<link rel="stylesheet" href="assets/css/main.css" />
		<link rel="stylesheet" href="assets/css/lp-icon.css" />
		<link rel="shortcut icon" href="assets/logo/logo.ico" type="image/x-icon">
		<noscript><link rel="stylesheet" href="assets/css/noscript.css" /></noscript>
	</head>
	<body class="is-preload">

		<!-- Sidebar -->
			<section id="sidebar">
				<div class="inner">
					<nav>
						<ul>
							<li><a href="#intro">환영합니다</a></li>
							<li><a href="#language">사용 가능한 언어</a></li>
							<li><a href="#Example">예</a></li>
						</ul>
					</nav>
				</div>
			</section>

		<!-- Wrapper -->
			<div id="wrapper">

				<!-- Intro -->
					<section id="intro" class="wrapper style1 fullscreen fade-up">
						<div class="inner">
							<h1>PHP 다국어 프레임 워크 v6.5</h1>
							<p>이 프로그램은 다양한 방식으로 구현 된 프레임 워크를 통해 구현 된 다국어 프로그램으로, 프레임 워크 디자인은 웹 사이트를 단순하고 빠르며 효율적으로 만족시킬 수있을뿐만 아니라 귀하를 만족시킬 수 있습니다.</p>
							<ul class="actions">
								<li><a href="https://lang-php.com/go/lp-docs" class="button scrolly">빠른 안내</a></li>
								<li><a href="https://lang-php.com/go/lp-downloads" class="button primary icon solid fa-download">다운로드</a></li>
							</ul>
						</div>
					</section>

				<!-- Language -->
					<section id="language" class="wrapper style2 fade-up">
						<div class="inner">
							<h2>국가 또는 지역을 선택하십시오.</h2>
							<h3>북아메리카</h3>
							<dt><span class="flag-icon flag-icon-us"></span>&nbsp; <a href="javascript:lang('en-US')">United States - English</a></dt>
							<br />
							<h3>아시아 태평양</h3>
							<dt><span class="flag-icon flag-icon-cn"></span>&nbsp; <a href="javascript:lang('zh-CN')">简体中文 - 中国</a></dt>
							<dt><span class="flag-icon flag-icon-tw"></span>&nbsp; <a href="javascript:lang('zh-TW')">繁體中文 - 中國</a></dt>
							<dt><span class="flag-icon flag-icon-jp"></span>&nbsp; <a href="javascript:lang('ja-JP')">日本 - 日本語</a></dt>
							<dt><span class="flag-icon flag-icon-kr"></span>&nbsp; <a href="javascript:lang('ko-KR')">대한민국 - 한국어</a></dt>
							<br />
							<h3>유럽</h3>
							<dt><span class="flag-icon flag-icon-ru"></span>&nbsp; <a href="javascript:lang('ru-RU')">Россия - Русский</a></dt>
						</div>
					</section>

				<!-- Example -->
					<section id="Example" class="wrapper style3 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>사용자 정의 선택 &amp; 카탈로그</h3>
									<p>첫 주행 후 조향 'choose-country-region' 디렉토리, 메모리 기능과 일치하는 언어 디렉토리를 선택하십시오.</p>
									<ul class="actions">
										<li><a href="example/01-directory" target="_blank" class="button primary fit">데모</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-one" target="_blank" class="button alt fit">빠른 안내</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt2" class="wrapper style4 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>내부적으로 파일로드 &amp; 임베디드</h3>
									<p>일치하는 디렉토리에서 파일을 자동으로 검색합니다. 파일이 없으면 기본 파일이 선택됩니다.</p>
									<ul class="actions">
										<li><a href="example/02-embed" target="_blank" class="button primary fit">데모</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-two" target="_blank" class="button alt fit">빠른 안내</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt3" class="wrapper style2 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>구성 파일 읽기 &amp; 로딩</h3>
									<p>自일치하는 언어 파일을 동적으로 검색하여로드 한 후 호출하며 문자열 문자, 배열, 매개 변수 등을 비롯한 HTML 을 지원합니다.</p>
									<ul class="actions">
										<li><a href="example/03-load" target="_blank" class="button primary fit">데모</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-three" target="_blank" class="button alt fit">빠른 안내</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt4" class="wrapper style3 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>설정 저장 &amp; 구성</h3>
									<p>예제와 동적 읽기 및 쓰기 Cookies 다릅니다. 구성을 xml 또는 cfg 에 저장하고 사용 가능한 기본 언어 팩을 선택하여 읽은 다음 브라우저의 기본 언어를 사용하지 마십시오.</p>
									<ul class="actions">
										<li><a href="example/04-settings" target="_blank" class="button primary fit">데모</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-four" target="_blank" class="button alt fit">빠른 안내</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt5" class="wrapper style4 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>데이터베이스 &amp; 배열</h3>
									<p>패스 PDO 길 연결 SQL 데이터베이스, 지원 MySQL, SQLite. 그리고 배열을 사용하십시오 (Array) 기능은 사용 가능한 모든 데이터를 나열합니다.</p>
									<ul class="actions">
										<li><a href="example/05-database" target="_blank" class="button primary fit">데모</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-fives" target="_blank" class="button alt fit">빠른 안내</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt6" class="wrapper style2 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h3>독립형 &amp; 포터블</h3>
									<p>사용 array() 언어 구조는 배열을 만들고 기능을 통해 모든 작업을 수행합니다. 다른 버전과 비교하여 이식 가능한 버전은 파일로 완성됩니다.</p>
									<ul class="actions">
										<li><a href="example/06-portable" target="_blank" class="button primary fit">데모</a></li>
										<li><a href="https://lang-php.com/go/lp-docs-six" target="_blank" class="button alt fit">빠른 안내</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

				<!-- License -->
					<section id="three" class="wrapper style1 fade-up">
						<div class="inner">
							<h2>다국어 웹 사이트를 만듭니다</h2>
							<p>다른 프레임 워크와 달리, Lang-php 디자인은 무제한이며 여러 솔루션을 제공합니다. 우리는 그것을 믿는다, 이러한 시나리오는 기존 규칙을 덮어 쓰는 것보다 훨씬 쉽습니다. 몇 줄의 코드를 추가하여, 여러 언어의 모양을 사용자 정의 할 수 있습니다 Web 함께 프로젝트하십시오.</p>
						</div>
					</section>

			</div>

		<!-- Footer -->
			<footer id="footer" class="wrapper style1-alt">
				<div class="inner">
					<ul class="menu">
						<li>&copy; Lang-php. All rights reserved.</li>
						<li>Design: <a href="https://fengyi.tel">Yi</a></li>
					</ul>
				</div>
			</footer>

		<!-- Scripts -->
			<script src="assets/js/jquery.min.js"></script>
			<script src="assets/js/jquery.scrollex.min.js"></script>
			<script src="assets/js/jquery.scrolly.min.js"></script>
			<script src="assets/js/browser.min.js"></script>
			<script src="assets/js/breakpoints.min.js"></script>
			<script src="assets/js/util.js"></script>
			<script src="assets/js/main.js"></script>
			<script src="assets/js/lp.js"></script>
<?php include "themes/analytics.php"; ?>
	</body>
</html>